package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.converter.UserRefreshHistoryConverter;
import gov.va.genisis2.dao.IUserRefreshHistoryDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.UserRefreshHistory;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserRefreshHistoryDaoTest extends AbstractMockMvcTests {

	/** The userRefreshHistoryDao. */
	@Autowired
	private IUserRefreshHistoryDao userRefreshHistoryDao;
	
	@Autowired
	private UserRefreshHistoryConverter userRefreshHistoryConverter;

	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisDAOException.class)
	public void test1CreateUserRefreshHistoryNullEntity() throws GenisisDAOException {
		userRefreshHistoryDao.createUserRefreshHistory(null);
	}
	
	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = DataIntegrityViolationException.class)
	public void test2CreateUserRefreshHistory_Null() throws GenisisDAOException {
		userRefreshHistoryDao.createUserRefreshHistory(new UserRefreshHistory());
	}
	
	/**
	 * Test createUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test3CreateUpdateUserRefreshHistory() throws GenisisDAOException {
		UserRefreshHistory userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("test");
		int id = userRefreshHistoryDao.createUserRefreshHistory(userRefreshHistory);
		assertTrue(id > 0);
		
		userRefreshHistory.setId(id);
		userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory);
		UserRefreshHistory updatedEntity = userRefreshHistoryDao.updateUserRefreshHistory(userRefreshHistory);
		
		assertNotNull(updatedEntity.getEndDate());
		assertEquals(RefreshStatusEnum.COMPLETED.getDesc(), updatedEntity.getStatus());
	}

	/**
	 * Test updateUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = IllegalStateException.class)
	public void test4UpdateUserRefreshHistory_Null() throws GenisisDAOException {
		UserRefreshHistoryDao dao = new UserRefreshHistoryDao();
		dao.setSessionFactory(null);
		userRefreshHistoryDao.updateUserRefreshHistory(new UserRefreshHistory());
	}

	/**
	 * Test getLatestUserRefreshHistory.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void test5GetLatestUserRefreshHistory() throws GenisisDAOException {
		assertNotNull(userRefreshHistoryDao.getLatestUserRefreshHistory());
	}

	@Test(expected = GenisisDAOException.class)
	public void test6GetLatestUserRefreshHistory_Error() throws GenisisDAOException {
		UserRefreshHistoryDao dao = new UserRefreshHistoryDao();
		dao.setSessionFactory(null);
		dao.getLatestUserRefreshHistory();
	}
}
